package hitme;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.Random;

/**
 * Title:        Reaksjonstest
 * Description:  Enkel applet for  mle og framstille resultatet av reaksjonstester. Del av emnehefte Statistikk i Vi p Vindusrekka.
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Brre Stenseth
 * @version 1.0
 */

public class HitApplet extends Applet
{
  // hand made data
  Rectangle bigR=null;
  Rectangle hitR=null;

  boolean bExperimenting=false;

  Random rnd=new Random(12121);
  // collecting time between hits
  final int limit=10;
  long results[]=null;
  int columns[]=null;
  int obscount=0;
  long starttime=0;

  boolean isStandalone = false;
  Button goButton = new Button();
  Button hitButton = new Button();
  Label ialt = new Label();
  Label snitt = new Label();
  Label korteste = new Label();
  Label lengste = new Label();
  Label intervallet = new Label();

  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  /**Construct the applet*/
  public HitApplet() {
  }
  /**Initialize the applet*/
  public void init() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  /**Component initialization*/
  private void jbInit() throws Exception {
    goButton.setLabel("Start");
    goButton.setBounds(new Rectangle(349, 7, 95, 56));
    goButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        goButton_actionPerformed(e);
      }
    });
    this.setLayout(null);
    hitButton.setBackground(Color.red);
    hitButton.setLabel("0");
    hitButton.setBounds(new Rectangle(339, 102, 61, 34));
    hitButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        hitButton_actionPerformed(e);
      }
    });
    ialt.setText("label1");
    ialt.setVisible(false);
    ialt.setBounds(new Rectangle(3, 3, 334, 19));
    snitt.setText("label1");
    snitt.setVisible(false);
    snitt.setBounds(new Rectangle(0, 74, 329, 24));
    korteste.setText("label1");
    korteste.setVisible(false);
    korteste.setBounds(new Rectangle(2, 26, 338, 19));
    lengste.setText("label2");
    lengste.setVisible(false);
    lengste.setBounds(new Rectangle(3, 48, 322, 27));
    intervallet.setText("label1");
    intervallet.setVisible(false);
    intervallet.setBounds(new Rectangle(3, 324, 443, 20));
    this.add(hitButton, null);
    this.add(ialt, null);
    this.add(korteste, null);
    this.add(lengste, null);
    this.add(snitt, null);
    this.add(goButton, null);
    this.add(intervallet, null);

    // pick up dimensions
    bigR=new Rectangle(0,0,400,400);
    hitR=hitButton.getBounds();

    // hide the panel, we use it only as placmarker
    // hide the target until we start an experiment
    hitButton.setVisible(false);
    // hide resultstrings
  }


  public void start() {
  }


  public void stop()
  {
    stopExperiment();
  }


  public void destroy() {
  }

  public String getAppletInfo() {
    return "Applet Information";
  }

  public String[][] getParameterInfo() {
    return null;
  }

  void goButton_actionPerformed(ActionEvent e)
  {
    // starting or stopping a series of experiments
    if(bExperimenting)
      stopExperiment();
    else
      startExperiment();
    repaint();
  }

 void hitButton_actionPerformed(ActionEvent e)
  {
    if(obscount == limit-1)
      stopExperiment();
    else
    {
      obscount=obscount+1;
      setTarget();
      hitButton.setLabel(new Integer(obscount).toString());
      hitButton.setVisible(true);
      results[obscount]=System.currentTimeMillis()-starttime;
      starttime=System.currentTimeMillis();
     }
     repaint();
  }

  void setTarget()
  {
      // set hitButton to a new position
        int x=rnd.nextInt(bigR.width-hitR.width);
        int y=rnd.nextInt(bigR.height-hitR.height);
        hitButton.setBounds(bigR.x+x,bigR.y+y,hitR.width,hitR.height);
  }

  void ShowResults(Graphics g)
  {
      // number of trials
      int ix;
      float min=results[1];
      float max=results[1];
      for(ix=1;ix<=obscount;ix++)
      {
        if(results[ix]>max) max=results[ix];
        if(results[ix]<min) min=results[ix];
      }

      // average
      float sum=0.0f;
      for(ix=1;ix<=obscount;ix++)
        sum=sum+results[ix]/1000.0f;
      sum=sum/obscount;

      ialt.setText("Du har gjort "+ new Integer(obscount).toString() +" forsk");
      korteste.setText(" - Lengste tid er: "+new Float(max/1000).toString()+" sekunder");
      lengste.setText(" - Korteste tid er: "+new Float(min/1000).toString()+" sekunder");
      snitt.setText(" - Gjennomsnitt = "+ new Float(sum).toString()+" sekunder");

      // histogram 1/10 , 1/2 or 1 second as interval
      float interval=0.0f;
      if(max < 5000.0f)
        interval=0.1f;
      else if (max < 25000)
        interval=0.5f;
      else
        interval=1.0f;
      intervallet.setText("Histogram med intervall: "+  new Float(interval).toString()+ " sekunder");

      columns=new int[100];
      for(ix=1;ix<100;ix++) columns[ix]=0;


      int maxcount=0;
      int maxcol=0;
      for(ix=1;ix<=obscount;ix++)
      {
        int colnr=(int)(results[ix]/(interval*1000));
        columns[colnr]++;
        if(colnr > maxcol)
          maxcol=colnr;
        if(columns[colnr]>maxcount)
          maxcount=columns[colnr];
      }

      // draw it
      int XAxis=300;
      int H=200;
      int W=300;
      int w=W/maxcol;
      int h=H/maxcount;

      // Y-axis
      g.drawLine(0,XAxis,0,XAxis-H);
      if(h >3)
      {
          for(ix=0;ix<maxcount;ix++)
            g.drawLine(0,XAxis-ix*h,2,XAxis-ix*h);
      }

      // X-axis
      g.drawLine(0,XAxis,W,XAxis);
      if(w > 3)
      {
        for(ix=0;ix<50;ix++)
          g.drawLine(ix*w,XAxis-1,ix*w,XAxis+1);
      }

      // columns
      for(ix=0;ix<50;ix++)
      if(columns[ix]>0)
      {
        g.drawRect(ix*w,
                  XAxis-columns[ix]*h,
                  w,
                  columns[ix]*h);
        g.setColor(Color.red);
        g.fillRect(ix*w+1,
                  XAxis-columns[ix]*h+1,
                  w-1,
                  columns[ix]*h-1);
      }

  }

  public void paint(Graphics g)
  {
    /**@todo: Override this java.awt.Container method*/
    super.paint( g);


    if(bExperimenting)
    {
      ialt.setVisible(false);
      snitt.setVisible(false);
      lengste.setVisible(false);
      korteste.setVisible(false);
      hitButton.setVisible(true);
      intervallet.setVisible(false);
      goButton.setLabel("Stop");

    }
    else
    {
       hitButton.setVisible(false);
       goButton.setLabel("Start");

       if(obscount>0)
        {
            ShowResults(g);
            ialt.setVisible(true);
            snitt.setVisible(true);
            lengste.setVisible(true);
            korteste.setVisible(true);
            intervallet.setVisible(true);
        }
    }
  }

  void startExperiment()
  {
        // start experiment
        bExperimenting=true;
        results=new long[limit+2];
        obscount=0;
        setTarget();
        hitButton.setLabel("0");
        starttime=System.currentTimeMillis();
  }

  void stopExperiment()
  {
        // stop experiment
        bExperimenting=false;
  }

}