// ////////////////////////////////////////////////////
//
// StdView.h : interface of the CStdView class
// Based on class COGLView : public CView
// Inspect COGLView for standard OpenGL initialization
//
////////////////////////////////////////////////////////
#include "oglview.h"

class CStdView : public COGLView
{
protected: 
	CStdView();
	DECLARE_DYNCREATE(CStdView)

// Attributes
private:
	// positioning by hand
	GLfloat m_xv,m_yv;
	CPoint 	m_PLast;
	// for zooming
	GLfloat m_dist;

	// hilited object
	GLint m_hilited;

	// render or hit
	GLenum m_Drawing_Mode;

// Operations
public:
	CStdDoc* GetDocument();
	virtual void DrawScene();
	virtual void InitializeRContext();
	virtual void SetPerspective(int cx, int cy);
	int PickObject(int x, int y);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStdView)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CStdView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CStdView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnZoomCloseup();
	afx_msg void OnZoomFjernere();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in StdView.cpp
inline CStdDoc* CStdView::GetDocument()
   { return (CStdDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
