// ////////////////////////////////////////////////////
//
// StdView.cpp : implementation of the CStdView class
// Based on class COGLView : public CView
// Inspect COGLView for standard OpenGL initialization
//
////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Std.h"

#include "StdDoc.h"
#include "StdView.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////
// You can put definitions, variables and helperfunctions
// here. Functions that does not rely on CStdView member
// variables or functions
#define NO_OBJECT -99	// signal no object hilited
#define BUFSIZE 1024		// store hits, ample size. Need only 4*possible hits

////////////////////////////////////////////////////////////////////////////
// a torus function

void DrawTorus(GLfloat R,GLfloat r,int N,int n,GLuint mode)
{
	//	use parametric expression
	//	z=r.sin(v)
	//	y=(R+rcos(v))sin(w)
	//	x=(R+rcos(v))cos(w)
	//	v running around body of torus
	//	w running round the hole
	//
	//	Strategy:
	//	Assume a larger torus with large radius rr=1.5*r
	//  Normal at any point should be from small to large
	//	Run v as inner loop

	#define maxn 1000 // max precision
	#define pi  3.14159265359f
	n=min(n,maxn-1);
	N=min(N,maxn-1);
	float rr=1.5f*r;

	double dv=2*pi/n;
	double dw=2*pi/N;
	
	double v=0.0f;
	double w=0.0f;

	// outer loop
	while(w<2*pi+dw)
	{
		v=0.0f;
		glBegin(mode);
		while(v<2*pi+dv)
		{
			glNormal3d((R+rr*cos(v))*cos(w)-(R+r*cos(v))*cos(w),
					   (R+rr*cos(v))*sin(w)-(R+r*cos(v))*sin(w),
					    rr*sin(v)-r*sin(v));
			glVertex3d((R+r*cos(v))*cos(w),
					   (R+r*cos(v))*sin(w),
					    r*sin(v));
			
			glNormal3d((R+rr*cos(v+dv))*cos(w+dw)-(R+r*cos(v+dv))*cos(w+dw),
					   (R+rr*cos(v+dv))*sin(w+dw)-(R+r*cos(v+dv))*sin(w+dw),
					    rr*sin(v+dv)-r*sin(v+dv));
			glVertex3d((R+r*cos(v+dv))*cos(w+dw),
					   (R+r*cos(v+dv))*sin(w+dw),
					    r*sin(v+dv));

			v+=dv;
		} // inner loop
		glEnd();
		w+=dw;
	} //outer loop
}


//////////////////////////////////////////////////////////
// CStdView

IMPLEMENT_DYNCREATE(CStdView, COGLView)

BEGIN_MESSAGE_MAP(CStdView, COGLView)
	//{{AFX_MSG_MAP(CStdView)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_ZOOM_CLOSEUP, OnZoomCloseup)
	ON_COMMAND(ID_ZOOM_FJERNERE, OnZoomFjernere)
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////
// CStdView construction/destruction

CStdView::CStdView()
{
	// initialize angles, see DrawScene
	m_xv=-60.0f;
	m_yv=0.0f;
	// zoom dist. ie. dist from eye 
	m_dist=-65.0f;
	// no one hilted initially
	m_hilited=NO_OBJECT;

	m_Drawing_Mode=GL_RENDER;

}::COGLView();

CStdView::~CStdView()
{}

////////////////////////////////////////////////////////////
// CStdView diagnostics
// You should usually not touch these:
#ifdef _DEBUG
void CStdView::AssertValid() const
{COGLView::AssertValid();}
void CStdView::Dump(CDumpContext& dc) const
{COGLView::Dump(dc);}

CStdDoc* CStdView::GetDocument() // non-debug version is inline
{	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CStdDoc)));
	return (CStdDoc*)m_pDocument;
}
#endif //_DEBUG

//////////////////////////////////////////////////////////////
// CStdView operations

void CStdView::DrawScene()
{
	// Clear the color and depth buffers.
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		
	// Set up for scene
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	// take it down z to make it visible accordning to
	// default viewing direction and perspective as set in onsize
	glTranslatef(0.0f,0.0f,m_dist);
	// rotate around x-axis 
	glRotatef(m_xv,1.0f,0.0f,0.0f);
	// rotate around z-axis 
	glRotatef(m_yv,0.0f,0.0f,1.0f);
	

	// make ogl nomalize normals
	glEnable(GL_NORMALIZE);

	// draw a chain of toruser around origo
	int ix;
	int n=10;//20
	GLfloat bigR=15.0f;
	GLfloat ringR=8.0f;//4
	GLfloat thickR=0.7f;//0.5
	for (ix=0;ix< n; ix++)
	{
		glPushMatrix();
		if(ix%2==1)
		{
			glRotatef((360.0f*ix)/(1.0f*n)+(0.25f*360.0f/(1.0f*n)),0.0f,0.0f,1.0f);
			glTranslatef(bigR,0.0f,0.0f);
			glRotatef(90.0,0.0f,1.0f,0.0f);
		}
		else
		{
			glRotatef((360.0f*ix)/(1.0f*n),0.0f,0.0f,1.0f);
			glTranslatef(bigR,0.0f,0.0f);
		}
		if(m_hilited==ix)
			CMaterial::SetMaterial(RED_PLASTIC);
		else
			CMaterial::SetMaterial(GOLD);
		if(m_Drawing_Mode==GL_SELECT)
		{
			glLoadName(ix);
			DrawTorus(ringR,thickR,20,10,GL_TRIANGLE_STRIP);// faster
		}
		else
			DrawTorus(ringR,thickR,40,20,GL_TRIANGLE_STRIP);
		glPopMatrix();
	}

	
	// finnish drawing
	glFlush();
}

void CStdView::InitializeRContext()
{
	// Here we set the attributes that will be constant
	// during the rendering contexts lifetime
    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    
	// prepare ligthsource
	GLfloat ambient[] = {0.2f,0.2f,0.2f,1.0f };
    GLfloat diffuse[] = {1.0f,1.0f,1.0f,1.0f };
    GLfloat position[] = {20.0f,30.0f,10.0f,0.0f };
    GLfloat lmodel_ambient[] = {0.4f,0.4f,0.4f,1.0f };


    glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
    glLightfv(GL_LIGHT0, GL_POSITION, position);
	
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHTING);
	
	// smooth the drawing
	glShadeModel(GL_SMOOTH);

    // set background to white
	glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
}

void CStdView::SetPerspective(int cx, int cy) 
{
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	gluPerspective(60.0f, (GLdouble)cx/cy, 0.1f, 1000.0f);
	glMatrixMode(GL_MODELVIEW);
}


void CStdView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// User has pressed left button.Make a note
	// of this and prepare for intuitive rotation of scene
	m_PLast=point;
	SetCapture();
	CView::OnLButtonDown(nFlags, point);
}

void CStdView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// free capture and terminate rotation
	ReleaseCapture();
	CView::OnLButtonUp(nFlags, point);
}

void CStdView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// if left button is down 
	if(nFlags & MK_LBUTTON)
	{	
		// and has moved a significant dist
		if((abs(m_PLast.x-point.x)>2)||(abs(m_PLast.y-point.y)>2))
		{
			// then we find an intuitive rot angle
			CRect R;
			GetClientRect(&R);
			
			m_yv+=90.0f*((GLfloat (point.x-m_PLast.x))/GLfloat (R.Width()));
			m_xv+=90.0f*((GLfloat (point.y-m_PLast.y))/GLfloat (R.Height()));
			
			// rememeber point and force immediate redraw 
			m_PLast=point;
			RedrawWindow();
		}
	}
}

void CStdView::OnZoomCloseup() 
{
	m_dist+=1.0f;
	if (m_dist>-2.0f)
		m_dist=-2.0f;
	RedrawWindow();
}

void CStdView::OnZoomFjernere() 
{
	m_dist-=1.0f;
	RedrawWindow();
}

int CStdView::PickObject(int x, int y)
{
	// called when mousedown to identify an object, if any
	
	// must set proper rendering context
	wglMakeCurrent(m_hDC,m_hRC);
	GLuint selectBuf[BUFSIZE]; // to store OGLs reports
	GLint hits;
	GLint viewport[4];// to store current viewport

	glGetIntegerv(GL_VIEWPORT,viewport);// get viewport
	glSelectBuffer(BUFSIZE,selectBuf);// tell OGL where to report
	glRenderMode(GL_SELECT);// as opposed to GL_RENDER

	glInitNames();
	glPushName(99); // since -1 gives a warning

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	// set up a small clipping pyramid
	gluPickMatrix(	(GLdouble)x,(GLdouble)(viewport[3]-y),//center
					5.0f,5.0f, // extension
					viewport);

	// same view as we see it,
	// same as in OnSize
	CRect R;
	GetClientRect(&R);
	gluPerspective(	60.0f,(GLdouble)R.Width()/(GLdouble)R.Height(),
					0.1f,1000.0f);
	glMatrixMode(GL_MODELVIEW);

	m_Drawing_Mode=GL_SELECT;
	DrawScene();// draw without rendering
	m_Drawing_Mode=GL_RENDER;

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	
	hits=glRenderMode(GL_RENDER);// gives me a hitcount
	
	// process the ix+1 hits
	// selectBuf contents:
	//	ix  : number of names on the hitstack when hit occurred
	//	ix+1: min z-depth of "object" associated with name, relative
	//	ix+2: max z-depth of "object" associated with name, relative
	//	ix+3: the name, ie index, assosiated with the hit
	//	etc
	if(hits ==0)
		return NO_OBJECT;
	else
	{
		// we have hit one or more "objects"
		// if only one we simply select it
		if(hits ==1)
			return selectBuf[3];//the only one in store

		// more than one is hit.  Which should we select ?
		// The closest one, 
		// go for the one which closest part is closest
		GLint closestix=0;
		for(GLint ix=1;ix<hits;ix++)
			if(selectBuf[4*ix+1]<selectBuf[4*closestix+1])
				closestix=ix;
		return selectBuf[4*closestix+3];
	}
	wglMakeCurrent(0,0);

}


void CStdView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// User has clicked with right button to
	// identify an object
	GLint oldHilite=m_hilited;
	m_hilited=PickObject(point.x,point.y);
	if (m_hilited!=oldHilite)
		RedrawWindow();
	
	CView::OnRButtonDown(nFlags, point);
}
