#if !defined(AFX_OGLVIEW_H__958EC9EF_6BB2_11D1_8178_00A024DFF1B7__INCLUDED_)
#define AFX_OGLVIEW_H__958EC9EF_6BB2_11D1_8178_00A024DFF1B7__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// OGLView.h : header file
//
///////////////////////////////////////////////////////////////
/*
This class is a base view-class for simple OpenGL-programming
Applications should subclass this class to get a working view.

This class will draw a yellow sphere on a light gray background
if your subclass does not redefine any of the functionality
_____________________________________

The class handles the following:

Sets up the drawing environment.
Do one-time initialization of OpenGL-rendering context
Draws the actual scene
Handles some key messages (see below)
_____________________________

Handling following messages:

OnSize(), Redefined in most cases, the viewing pyramid, parallell
perspective, front and back clip

OnCreate(), usually not redefined

OnEraseBkgnd(), seldon (never) redefined

OnDestroy(), usually not redefined. Implementations 
in subclass must include a call to COGLView::OnDestroy()

PreCreateWindow(), seldon (never) redefined

OnDraw(), seldon (never) redefined

________________________________

Default funcions

InitializeRContext(), virtual function. Allmost allways 
redefined. Deals with lighting, back color, shading model etc. 
Things that will usually be done once in the programs lifetime

DrawScene(), virtual function. Allways redefined

_________________________________


*/


class COGLView : public CView
{
protected:
	COGLView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(COGLView)

// Attributes
protected:

	// a dc
	CClientDC* m_pDC;
	HDC m_hDC;

	// rendering context handle
	HGLRC m_hRC;


// Operations
public:
	virtual void DrawScene();
protected:
	virtual void SetUpDrawingEnvironment();
	virtual void InitializeRContext();
	virtual void SetPerspective(int cx, int cy);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COGLView)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~COGLView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(COGLView)
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OGLVIEW_H__958EC9EF_6BB2_11D1_8178_00A024DFF1B7__INCLUDED_)
