// OGLView.cpp : implementation file
//

#include "stdafx.h"
#include "Std.h"
#include "OGLView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COGLView

IMPLEMENT_DYNCREATE(COGLView, CView)

COGLView::COGLView()
{
	m_hRC=NULL;
	m_hDC=NULL;
}

COGLView::~COGLView()
{
}


BEGIN_MESSAGE_MAP(COGLView, CView)
	//{{AFX_MSG_MAP(COGLView)
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COGLView drawing

void COGLView::OnDraw(CDC* pDC)
{
	// The proper rendering context is set and released.
	// This must be done the same way in subclasses. 
	// if for some reason you want to redefine OnDraw()
	// No OpenGL-action must take place if we
	// have not attached the correct rendering context	
	wglMakeCurrent(m_hDC,m_hRC);
	DrawScene();
	SwapBuffers(wglGetCurrentDC());
	wglMakeCurrent(0,0);
}

/////////////////////////////////////////////////////////////////////////////
// COGLView diagnostics

#ifdef _DEBUG
void COGLView::AssertValid() const
{	CView::AssertValid();}

void COGLView::Dump(CDumpContext& dc) const
{	CView::Dump(dc);}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// COGLView message handlers

int COGLView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	// sets up the drawing environment and do
	// one time initialization of OGL-settings

	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
    m_pDC = new CClientDC(this);
	m_hDC=m_pDC->GetSafeHdc();
	ASSERT(m_hDC != NULL);
	
	// Set up the drawing environment
	SetUpDrawingEnvironment();
	return 0;
}

void COGLView::OnDestroy() 
{
	// only one dynamic variable to release
	if(m_pDC!=NULL)
		delete m_pDC;
	CView::OnDestroy();
	
}

void  COGLView::SetPerspective(int cx, int cy)
{
    // We will work on the projection matrix,
	// so set matrix mode
	glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	// set up your viewing volume
	// gluPerspective:	pyramide  
	gluPerspective(70.0f, (GLdouble)cx/cy, 0.1f, 70.0f);
	
	// Alternative: glOrtho:box, parallell projection
	// glOrtho(-2.0f,2.0f,-2.0f*cy/cx,2.0f*cy/cx,-10.f,10.0f);
	// NOTE: want x/y-ratio to match viewports x/y-ratio
	
	// set back matrix mode
	glMatrixMode(GL_MODELVIEW);
}


void COGLView::OnSize(UINT nType, int cx, int cy) 
{
	// Called whenever the size of the view changes
	// We must set the viewport in the rendering
	// context accordingly. The proper rendering context
	// is set and released.This must be done the same way
	// in subclasses. No OpenGL-action must take place if we
	// have not attached the correct rendering context
	// Since SetPerspective() is wrapped with the
	// proper rendering context set, we dont have to
	// tamper with the rendering context is redefinitions of
	// SetPerspective()

	CView::OnSize(nType, cx, cy);
	wglMakeCurrent(m_hDC,m_hRC);
	// use the whole clientarea
	glViewport(0, 0, cx, cy);
	SetPerspective(cx,cy);
	wglMakeCurrent(0,0);
}


BOOL COGLView::OnEraseBkgnd(CDC* pDC) 
{
	// To avoid flicker. This assures that
	// the clientarea is not blanked before a redraw starts
	// Ok as long as we draw in the whole clientarea
	return TRUE;
}

BOOL COGLView::PreCreateWindow(CREATESTRUCT& cs) 
{
	// all OpenGL windows must have this window-style
	cs.style|=WS_CLIPSIBLINGS|WS_CLIPCHILDREN;
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////
// default initializing of the drawing environment

void COGLView::SetUpDrawingEnvironment()
{
	// This function must be changed if you want
	// to bargain for other specs than those 
	// specified as initial values to
	// PIXELFORMATDESCRIPTOR below

   static PIXELFORMATDESCRIPTOR pfd = 
	{
        sizeof(PIXELFORMATDESCRIPTOR),  // size of this pfd
        1,                              // version number
        PFD_DRAW_TO_WINDOW |            // support window
        PFD_SUPPORT_OPENGL |          // support OpenGL
        PFD_DOUBLEBUFFER,             // double buffered
        PFD_TYPE_RGBA,                  // RGBA type
        24,                             // 24-bit color depth
        0, 0, 0, 0, 0, 0,               // color bits ignored
        0,                              // no alpha buffer
        0,                              // shift bit ignored
        0,                              // no accumulation buffer
        0, 0, 0, 0,                     // accum bits ignored
        32,                             // 32-bit z-buffer
        0,                              // no stencil buffer
        0,                              // no auxiliary buffer
        PFD_MAIN_PLANE,                 // main layer
        0,                              // reserved
        0, 0, 0                         // layer masks ignored
    };

   int nPixelFormat;

   nPixelFormat = ChoosePixelFormat(m_hDC, &pfd);
   SetPixelFormat(m_hDC, nPixelFormat, &pfd);
	
   DescribePixelFormat(m_hDC,nPixelFormat,
						sizeof(PIXELFORMATDESCRIPTOR),&pfd);
   if(pfd.dwFlags & PFD_NEED_PALETTE)
	   AfxMessageBox("Colors will not display properly,\nOnly 256 colors available\nNo palettehandling included");
	
	// create rendering context associated with  windows dc
	m_hRC=wglCreateContext(m_hDC);
	ASSERT(m_hRC!=NULL);
	// make the rendering context current while 
	wglMakeCurrent(m_hDC,m_hRC);
	// do one-time initializing
	InitializeRContext();
	// release the rendering context
	wglMakeCurrent(0,0);

}

//////////////////////////////////////////////////
// default DrawScene

void COGLView::DrawScene()
{
	// You will allways want to redefine this
	// in your subclass
	// Here we assume that the 
	// one and only rendering context is selected
	// If it for some reason is not, this must be
	// done before we do any OpenGL-action
	
	// Clear the color and depth buffers.
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		
	// Set up for scene
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	// position the eye relative to scene
	gluLookAt(	4.0f,0.0f,0.0f,	// eye
				0.0f,0.0f,0.0f,	// looking at
				0.0f,0.0f,1.0f);// is up
	
	// setMaterial kind of yellow
    GLfloat mat_ambient[] = { 0.7f, 0.7f, 0.7f, 1.0f };
    GLfloat mat_diffuse[] = { 0.8f, 0.8f, 0.0f, 1.0f };
	glMaterialfv(GL_FRONT, GL_AMBIENT, mat_ambient);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
	
	// use a quadric to draw a circle
	GLUquadricObj *glpQ;
	glpQ=gluNewQuadric();
	gluSphere(glpQ,1,20,20);
	gluDeleteQuadric(glpQ);

	// finnish drawing
	glFlush();
}

//////////////////////////////////////////////////
// default one-time initialization

void COGLView::InitializeRContext()
{
	// Here we set the attributes that probably
	// will be constant during the rendering 
	// contexts lifetime.

	// you may or may not want this function
	// If you dont need it, simply redefine an empty
	// function in your subclass

	// The proper rendering context is set and released.
	// before and after the one and only call to this function,
	// in function SetUpDrawingEnvironment()
	// so we dont have to bother with the rendering context here
	// or in a redefinition

    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    
	// prepare ligthsource
	GLfloat ambient[] = {0.2f,0.2f,0.2f,1.0f };
    GLfloat diffuse[] = {1.0f,1.0f,1.0f,1.0f };
    GLfloat position[] = {20.0f,30.0f,10.0f,0.0f };
    GLfloat lmodel_ambient[] = {0.4f,0.4f,0.4f,1.0f };


    glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
    glLightfv(GL_LIGHT0, GL_POSITION, position);
	
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHTING);
	
	// smooth the drawing
	glShadeModel(GL_SMOOTH);

    // set background to light gray
	glClearColor(0.8f, 0.8f, 0.8f, 0.0f);
}

