////////////////////////////////////////////////////////
// mater.h : class CMaterial
//
// The Class CMaterial is a class for
// selection of material properties.
// It offers many mechanisms for selection:
//	-	Direct selection from the programcode
//		Selection by index 
//	-	Selection from a dialogbox with a combobox
//		That is why the class is based on CDialog (IDD_MULTI)
//	-	Selection by menu. The class offers to
//		construct a CMenu from actual strings. 
//		This CMenu can in turn be attached to 
//		a windows menu, or appear as a popup
//	-	CMaterial can also be used as a static object
//		Function SetMaterial may be called directly,
//		without declaring a CMaterial object. If you include
//		mater.h in stdAfx.h, the call CMaterial::SetMaterial
//		is allways available
// BS 96, modified jan 97
// 
/////////////////////////////////////////////////////////


#ifndef _MATERIAL_
#define _MATERIAL_

#include "resource.h"

// enum to identify all the materials
// extracted to .h file to make it available
// for using class

#define NUM_MATERIALS 28

static enum {
    EMERALD = 0,JADE,OBSIDIAN,PEARL,RUBY,TURQUOISE,
    BRASS,BRONZE,CHROME,COPPER,GOLD,SILVER,
    BLACK_PLASTIC,CYAN_PLASTIC,GREEN_PLASTIC,
		RED_PLASTIC,WHITE_PLASTIC,YELLOW_PLASTIC,
    BLACK_RUBBER,CYAN_RUBBER,GREEN_RUBBER,
		RED_RUBBER,WHITE_RUBBER,YELLOW_RUBBER,
	BRIGHT_WHITE,LESS_BRIGHT_WHITE,
		WARM_WHITE,COOL_WHITE
};

class CMaterial : public CDialog
{
// Construction
public:
	CMaterial(CWnd* pParent = NULL);

// Dialog Data
	//{{AFX_DATA(CMaterial)
	enum { IDD = IDD_MULTI };
	CComboBox	m_Combo;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMaterial)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

// Implementation
protected:
	UINT m_CurrentIndex;
	// current selection, allways legitimate

	void Do_It(GLenum gSide);
	// realize current selection

	CString Get_Name(UINT ix);
	// return the namestring with index ix

public:
	static void SetMaterial(UINT ix,GLenum gSide = GL_FRONT_AND_BACK);
	// realizes a material without changing locals (of course)

	static UINT Get_Material_Count(){return NUM_MATERIALS;};
	// returns the number of materials

	UINT Build_Menu(UINT FirstID,CMenu *pM);
	// fills a menu from all the strings

	UINT Build_Combo(CComboBox* pCB);
	// fills a combobox from all the strings

	UINT Get_Current_Index();
	// returns the current selection

	void Get_Current_Name(CString& S);
	// returns the name associated with the current selection

	void Set_Current_Index(UINT ix);
	// changes the current selection without action

	void Do_Selection(GLenum gSide = GL_FRONT_AND_BACK);
	// perform the current selction

	void Select_And_Do(UINT ix,GLenum gSide = GL_FRONT_AND_BACK);
	// combination of the two above

protected:

	// Generated message map functions
	//{{AFX_MSG(CMaterial)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif //_MATERIAL_
