/////////////////////////////////////////////////
// mater.cpp : implements class CMaterial
//
// BS 96, modified jan 97
// 
//////////////////////////////////////////////////
//
#include "stdafx.h"
#include "mater.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// Materials serves as an index with one entry for
// each of the NUM_MATERIALS materials, see material.h

static int Materials[NUM_MATERIALS] = {
    EMERALD,JADE,OBSIDIAN,PEARL,RUBY,TURQUOISE,
    BRASS,BRONZE,CHROME,COPPER,GOLD,SILVER,
    BLACK_PLASTIC,CYAN_PLASTIC,GREEN_PLASTIC,
		RED_PLASTIC,WHITE_PLASTIC,YELLOW_PLASTIC,
    BLACK_RUBBER,CYAN_RUBBER,GREEN_RUBBER,
		RED_RUBBER,WHITE_RUBBER,YELLOW_RUBBER,
	BRIGHT_WHITE,LESS_BRIGHT_WHITE,
		WARM_WHITE,COOL_WHITE
};

// material names
static CString MatNames[NUM_MATERIALS]=
{
    "EMERALD","JADE","OBSIDIAN","PEARL","RUBY","TURQUOISE",
    "BRASS","BRONZE","CHROME","COPPER","GOLD","SILVER",
    "BLACK_PLASTIC","CYAN_PLASTIC","GREEN_PLASTIC",
		"RED_PLASTIC","WHITE_PLASTIC","YELLOW_PLASTIC",
    "BLACK_RUBBER","CYAN_RUBBER","GREEN_RUBBER",
		"RED_RUBBER","WHITE_RUBBER","YELLOW_RUBBER",
	"BRIGHT_WHITE","LESS_BRIGHT_WHITE",
		"WARM_WHITE","COOL_WHITE"
};

// description of materials, 13 floating values each:
// ambient(RGBA), diffuse(RGBA), specular(RGBA), shininess
// A=1.0f for all

static GLfloat Material[NUM_MATERIALS][13] = {
     //EMERALD
		0.0215f, 0.1745f, 0.0215f,1.0f,
        0.07568f, 0.61424f, 0.07568f, 1.0f,
		0.633f, 0.727811f, 0.633f, 1.0f,
		0.6f,
     //JADE
		0.135f, 0.2225f, 0.1575f,1.0f,
        0.54f, 0.89f, 0.63f, 1.0f,
		0.316228f, 0.316228f, 0.316228f, 1.0f,
		0.1f,
     //OBSIDIAN
		0.05375f, 0.05f, 0.06625f, 1.0f,// XX
        0.18275f, 0.17f, 0.22525f, 1.0f,
		0.332741f, 0.328634f, 0.346435f,1.0f, 
		0.3f,
     //PEARL
		0.25f, 0.20725f, 0.20725f,1.0f,
        1.0f, 0.829f, 0.829f, 1.0f,
		0.296648f, 0.296648f, 0.296648f, 1.0f,
		0.088f,
     //RUBY
		0.1745f, 0.01175f, 0.01175f,1.0f,
        0.61424f, 0.04136f, 0.04136f, 1.0f,
		0.727811f, 0.626959f, 0.626959f, 1.0f,
		0.6f,
     //TUQUOISE
		0.1f, 0.18725f, 0.1745f,1.0f,
        0.396f, 0.74151f, 0.69102f, 1.0f,
		0.297254f, 0.30829f, 0.306678f, 1.0f,
		0.1f,
     //BRASS
		0.329412f, 0.223529f, 0.027451f,1.0f,
        0.780392f, 0.568627f, 0.113725f, 1.0f,
		0.992157f, 0.941176f, 0.807843f,1.0f,
        0.21794872f,
     //BRONZE
		0.2125f, 0.1275f, 0.054f,1.0f,
        0.714f, 0.4284f, 0.18144f, 1.0f,
		0.393548f, 0.271906f, 0.166721f, 1.0f,
		0.2f,
     //CHROME
		0.25f, 0.25f, 0.25f, 1.0f, // XX
        0.4f, 0.4f, 0.4f, 1.0f,
		0.774597f, 0.774597f, 0.774597f, 1.0f,
		0.6f,
     //COPPER
		0.19125f, 0.0735f, 0.0225f,1.0f,
        0.7038f, 0.27048f, 0.0828f, 1.0f,
		0.256777f, 0.137622f, 0.086014f, 1.0f,
		0.1f,
     //GOLD
		0.24725f, 0.1995f, 0.0745f,1.0f,
        0.75164f, 0.60648f, 0.22648f, 1.0f,
		0.628281f, 0.555802f, 0.366065f, 1.0f,
		0.4f,
     //SILVER
		0.19225f, 0.19225f, 0.19225f,1.0f,
        0.50754f, 0.50754f, 0.50754f, 1.0f,
		0.508273f, 0.508273f, 0.508273f, 1.0f,
		0.4f,
     //BLACK PLASTIC
		0.0f, 0.0f, 0.0f, 1.0f,
		0.01f, 0.01f, 0.01f,1.0f,
        0.50f, 0.50f, 0.50f, 1.0f,
		.25f,
     //CYAN PLASTIC
		0.0f, 0.1f, 0.06f, 0.0f, 1.0f,
		0.50980392f, 0.50980392f,1.0f,
        0.50196078f, 0.50196078f, 1.0f,
		0.50196078f, 
		.25f,
     //GREEN PLASTIC
		0.0f, 0.0f, 0.0f,1.0f,
        0.1f, 0.35f, 0.1f, 1.0f,
		0.45f, 0.55f, 0.45f, 1.0f,
		.25f,
     //RED PLASTIC
		0.0f, 0.0f, 0.0f, 1.0f,
		0.5f, 0.0f, 0.0f, 1.0f,// XX
        0.7f, 0.6f, 0.6f, 1.0f,
		.25f,
     //WHITE PLASTIC
		0.0f, 0.0f, 0.0f, 1.0f,
		0.55f, 0.55f, 0.55f,1.0f,
        0.70f, 0.70f, 0.70f, 1.0f,
		.25f,
     //YELLOW PLASTIC
		0.0f, 0.0f, 0.0f, 1.0f,
		0.5f, 0.5f, 0.0f,1.0f,
        0.60f, 0.60f, 0.50f, 1.0f,
		.25f,
     //BLACK RUBBER
		0.02f, 0.02f, 0.02f, 1.0f,
		0.01f, 0.01f, 0.01f, 1.0f,// XX
        0.4f, 0.4f, 0.4f, 1.0f,
		.078125f,
     //CYAN RUBBER
		0.0f, 0.05f, 0.05f, 1.0f,
		0.4f, 0.5f, 0.5f,1.0f,
        0.04f, 0.7f, 0.7f, 1.0f,
		.078125f,
     //GREEN RUBBER
		0.0f, 0.05f, 0.0f, 1.0f,
		0.4f, 0.5f, 0.4f,1.0f,
        0.04f, 0.7f, 0.04f, 1.0f,
		.078125f,
     //RED RUBBER
		0.05f, 0.0f, 0.0f, 1.0f,
		0.5f, 0.4f, 0.4f,1.0f,
        0.7f, 0.04f, 0.04f, 1.0f,
		.078125f,
     //WHITE RUBBER
		0.05f, 0.05f, 0.05f, 1.0f,
		0.5f, 0.5f, 0.5f,1.0f,
        0.7f, 0.7f, 0.7f, 1.0f,
		.078125f,
     //YELLOW RUBBER
		0.05f, 0.05f, 0.0f, 1.0f,
		0.5f, 0.5f, 0.4f,1.0f,
        0.7f, 0.7f, 0.04f, 1.0f,
		.078125f,
	// bright white
		0.2f, 0.2f, 0.2f,1.0f,
        1.0f, 1.0f, 1.0f, 1.0f,
		0.8f, 0.8f, 0.8f, 1.0f,
		0.4f,
	// less bright white
		0.2f, 0.2f, 0.2f,1.0f,
        0.8f, 0.8f, 0.8f, 1.0f,
		0.5f, 0.5f, 0.5f, 1.0f,
		0.35f,
	// warmish white
		0.3f, 0.2f, 0.2f,1.0f,
        1.0f, 0.9f, 0.8f, 1.0f,
		0.4f, 0.2f, 0.2f, 1.0f,
		0.35f,
	// coolish white
		0.2f, 0.2f, 0.3f,1.0f,
        0.8f, 0.9f, 1.0f, 1.0f,
		0.2f, 0.2f, 0.4f, 1.0f,
		0.35f
};

void DoMaterial( GLfloat *pMat,GLenum gSide )
{
    // helper to fill the vector
	// use GL_FRONT when erronous gSide-value
	if((gSide!=GL_FRONT_AND_BACK)&&(gSide!=GL_BACK))
		gSide=GL_FRONT;

	glMaterialfv (gSide, GL_AMBIENT, pMat);
	pMat+=4;
	glMaterialfv (gSide, GL_DIFFUSE, pMat);
	pMat+=4;
	glMaterialfv (gSide, GL_SPECULAR, pMat);
	pMat+=4;
	glMaterialf (gSide, GL_SHININESS, *pMat*128.0f);
}

/////////////////////////////////////////////////////
// CMaterial

CMaterial::CMaterial(CWnd* pParent /*=NULL*/)
	: CDialog(CMaterial::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMaterial)
		// NOTE: the ClassWizard will add...
	//}}AFX_DATA_INIT
	m_CurrentIndex=0;
}


void CMaterial::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMaterial)
	DDX_Control(pDX, IDC_COMBO1, m_Combo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMaterial, CDialog)
	//{{AFX_MSG_MAP(CMaterial)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CMaterial::Do_It(GLenum gSide)
{
	// Realizes the current material
	DoMaterial( &Material[m_CurrentIndex][0],gSide);
}


CString CMaterial::Get_Name(UINT ix)
{
	// the name of current material
	return MatNames[ix];
}


UINT CMaterial::Build_Menu(UINT FirstID,CMenu *pM)
{
	// build menu from the stringlist
	UINT count=NUM_MATERIALS;
	for(UINT ix=0;ix<count;ix++)
		pM->AppendMenu(MF_STRING,FirstID+ix,Get_Name(ix));
	return count;
}

UINT CMaterial::Build_Combo(CComboBox* pCB)
{
	// fill into the combobox from the stringlist
	UINT count=NUM_MATERIALS;
	for(UINT ix=0;ix<count;ix++)
		pCB->AddString(Get_Name(ix));

	// mark current selection
	pCB->SetCurSel(m_CurrentIndex);
	return count;
}

UINT CMaterial::Get_Current_Index()
{
	return m_CurrentIndex;
}

void CMaterial::Get_Current_Name(CString& S)
{
	S=Get_Name(Get_Current_Index());
}

void CMaterial::Set_Current_Index(UINT ix)
{
	// force to range
	m_CurrentIndex=max(0,min(NUM_MATERIALS-1,ix));
}

void CMaterial::Do_Selection(GLenum gSide /*= GL_FRONT_AND_BACK*/)
{
	Do_It(gSide);
}

void CMaterial::Select_And_Do(UINT ix,GLenum gSide /*= GL_FRONT_AND_BACK*/)
{
	Set_Current_Index(ix);
	Do_It(gSide);
}


BOOL CMaterial::OnInitDialog() 
{
	CDialog::OnInitDialog();
	Build_Combo(&m_Combo);	
	return TRUE; 
}


void CMaterial::OnOK() 
{
	// Make the selection current index
	m_CurrentIndex=m_Combo.GetCurSel();
	CDialog::OnOK();
}

void CMaterial::SetMaterial(UINT ix,GLenum gSide /*= GL_FRONT_AND_BACK */)
{
	// force to range
	ix=max(0,min(NUM_MATERIALS-1,ix));
	DoMaterial( &Material[ix][0],gSide );
}